///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////

// Fragment shader from AmplitudeVelocity example
//
// Take intensity value from volume1 and color value from volume2.
//
// This shader works for slice primitives and for
// volume rendering, but must be instantiated twice. 
// This is because we need a shader node with the 
// 'forVolumeOnly' field set to false for rendering
// slices and another shader node with 'forVolumeOnly'
// set to true for volume rendering. Generally the
// first one (for slices) will be an SoVolumeShader
// node and the second one (for volume rendering) will 
// be an SoVolumeRenderingQuality node.

//!oiv_include <VolumeViz/vvizGetData_frag.h>
//!oiv_include <VolumeViz/vvizTransferFunction_frag.h>

uniform VVizDataSetId data1;
uniform VVizDataSetId data2;

vec4 blend(in vec3 texCoord)
{
  VVIZ_DATATYPE index1 = VVizGetData(data1, texCoord);
  vec4 data1Color = VVizTransferFunction(index1, 0);

  VVIZ_DATATYPE index2 = VVizGetData(data2, texCoord);
  vec4 data2Color = VVizTransferFunction(index2, 1);

  // Color modulated by intensity from volume2
  data2Color.rgb *= data1Color.r;
  data2Color.a   *= data1Color.a;
  return data2Color;
}

// Implement VVizComputeFragmentColor for slice nodes
vec4 VVizComputeFragmentColor(VVIZ_DATATYPE vox, vec3 texCoord)
{
  return blend(texCoord);
}

// Implement VVizComputeFragmentColor for SoVolumeRender
vec4 VVizComputeFragmentColor(VVizDataSetId data, vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, int maskId)
{
  return blend(voxelInfoFront.texCoord);
}
